
function AISMN_GoNearBuilding::OnEnter(%this, %data)
{
   %tar = GetParameterTarget(%data);
   if (%tar == 0)
   {
      SetVariable(%data, 0, 1);
      return;
   }
   
   SetPathForBuilding(%data, %tar, 1);
   
   %object = GetThisObject(%data);
   %object.playThread(0, "run");
   %object.unmountImage(2);
   %object.mountImage("waterpail", 2);
}

function AISMN_GoNearBuilding::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");

   RestoreCharacterOutfit(%data);
}

//EXIT 0: BUILDING DOES NOT EXIST
//EXIT 1: AT BUILDING
function AISMN_GoNearBuilding::Update(%this, %data)
{
   if (GetStateVariable(%data,0) >= 1)
   {
      ReturnValue(%data,0);
      return;
   }
   
   //Get the building component and target
   %tar = GetParameterTarget(%data);
   %component = slgQueryInterface(%tar, $CID_BUILDING);
   
   //If the object doesn't exist, it probably burned up.
   if (0 == %tar || 0 == %component)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   //If the object is no longer on fire, change states.
   if (%component.onFire() == false)
   {
      StopMoving(%data);
      ReturnValue(%data, 0);
      return;
   }
   
   if (!IsFollowingPath(%data))
   {
      ReturnValue(%data, 1);
      return;
   }
   
   //Stay in this state
   ReturnValue(%data, -1);
}
